/* THIS FILE IS A COPYRIGHT OF ELINS TECHNOLOGIES PVT. LTD.
   THIS FILE IS CREATED TO USE WITH ATOME VERSION V.1 DEVLOPMENT BOARD.	

	16X2 ALPHANUMERIC LCD CAN BE INTERFACED WITH FOLLOWING CONNECTIONS:
	RS -> PB2
	RW -> PB1
	EN -> PB0
	D4 -> PD4
	D5 -> PD5
	D6 -> PD6
	D7 -> PD7

	LCD IS PLACED IN 4 BIT MODE.
*/


#ifndef _atomelcd_h_
#define _atomelcd_h_

#include <delay.h>

void lcd_init(void);	//Initialise the lcd
void lcd_xy(int a,int b); //Go to (x,y) position
void latch(void);
void lcd_cmd(unsigned char cmd); //Send command
void lcd_char(unsigned char single); //Send character
void lcd_3d(unsigned int num); //Prints the integer number of 3 digit
void lcd_decimal(float num); // Prints the float number at max 99.99 	
void lcd_4d(unsigned int num); //Prints the integer number of 4 digit
void lcd_s(char *p); //Print string

void lcd_s(char *p)
{
while(*p!='\0')
{
lcd_char(*p);
p++;
}
}

void lcd_init(void)	//init the lcd
{	
    DDRB|=0x07;
    DDRD|=0xF0;
    PORTB&=~0x01;  //EN=0
    PORTB&=~0x04; //RS=0
    delay_ms(50);   
    lcd_cmd(0x20);	// 4 bit, 2 line, 5x8 dot   
    latch();   
    lcd_cmd(0x28);	// 4 bit, 2 line, 5x8 dot   
    latch();   
    lcd_cmd(0x06);	// display increment  
    latch();
     
    lcd_cmd(0x0C);	// display on cursor on
    delay_ms(50); 
    lcd_xy(0,0);
}

void lcd_3d(unsigned int num)	//prints the decimal 3digit value of num
{
	unsigned char H=0,T=0,O=0;
	H=num/100;
	T=(num - (H*100))/10;
	O=(num - (H*100) - (T*10));
	
	lcd_char(H+48);
	lcd_char(T+48);
	lcd_char(O+48);
}

void lcd_4d(unsigned int num)	//prints the decimal 3digit value of num
{
	unsigned char d0=0,d1=0,d2=0,d3=0;
	d3=(num/1000);
	d2=(num - (d3*1000))/100;
	d1=(num - (d3*1000) - (d2*100))/10;
	d0=(num - (d3*1000) - (d2*100)-(d1*10));
	
	lcd_char(d3+48);
	lcd_char(d2+48);
	lcd_char(d1+48);
	lcd_char(d0+48);
}


void lcd_decimal(float num)	//prints the decimal 3digit value of num
{
	unsigned char d0=0,d1=0,d2=0,d3=0;
	int num1=num*100;
	d3=(num1/1000);
	d2=(num1 - (d3*1000))/100;
	d1=(num1 - (d3*1000) - (d2*100))/10;
	d0=(num1 - (d3*1000) - (d2*100)-(d1*10));
	
	lcd_char(d3+48);
	lcd_char(d2+48);
	lcd_char('.');
	lcd_char(d1+48);
	lcd_char(d0+48);
}


void lcd_xy(int a,int b)
{
if(a==0)
lcd_cmd(0x80+b);
if(a==1)
lcd_cmd(0xC0+b);
}

void latch(void)
{
PORTB&=~0x01; //EN=0
delay_ms(10);  
PORTB|=0x01;	//EN=1
delay_ms(10);  
PORTB&=~0x01;
}

void lcd_cmd(unsigned char cmd)
{
	PORTB&=~0x06; //RS=0 , RW=0
	PORTD=((cmd&0xF0));	//MSB		
	latch();
	PORTD=((cmd&0x0F)<<4);	//LSB
	latch();
}


void lcd_char(unsigned char single)
{
	PORTB|=0x04; //RS=1
	PORTB&=~0x02; //RW=0
	PORTD=(single&0xF0)|0x01;						
	latch();
	PORTD=((single&(0x0F))<<4)|0x01;
	latch();     
}


#endif

