#include <Arduino.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266WiFi.h>  

#define LED D0  // DECLARE LED TO PIN D0 (ON BOARD LED)
#define IR D2 // DECLARE IR TO PIN D2 (IR SENSOR IS CONNECTED)

const char* ssid = "Elins Tech."; // PUT SSID OF YOUR WIFI HERE
const char* password = "jaimatadi21";  // PUT PASSWORD OF YOUR WIFI HERE


void setup() {
    delay(5000);  
    Serial.begin(9600); // INITIALIZE UART SERIAL MONITOR TO DISPLAY EVENTS  
    pinMode(LED,OUTPUT); // DECLARE LED PIN AS OUTPUT PIN
    pinMode(IR,INPUT); // DECLARE IR PIN AS INPUT PIN 
    digitalWrite(LED,0); // INITIALIZE LED PIN WITH 0 - ON LED
    
    Serial.println();
    Serial.println();
    Serial.println();

    WiFi.begin(ssid,password);  // START WIFI CONNECTION WITH SSID PASSWORD
    Serial.print("[CONNECTING] WAIT ...");
    
    while (WiFi.status() != WL_CONNECTED) // WAIT TILL WIFI IS CONNECTED
    {
      delay(100);
      Serial.print(".");
    }
    
    Serial.println("WIFI CONNECTED SUCCESSFULLY");    
}

String payload="";
String DeviceId="juvinagrawal651";  // CHANGE IT WITH DEVICE ID RECEIVED FROM CLOUD
HTTPClient http; 

int count;
void loop(){


if(digitalRead(IR)==0)  // IR SENSOR CODE TO COUNT NUMBER OF PACKAGES
{
  while(digitalRead(IR)==0)
  {
    delay(100);
  }
  count = count + 1;
  if(count>50)
  {
    count=0;
  }
  Serial.println(count);


// CODE TO UPLOAD SENSOR DATA ON ELINS CLOUD
if(WiFi.status() == WL_CONNECTED)
{
  String URL = "";
    URL = URL + "http://elinstechnologies.com/netobox_v1/http_ir_device.php?id=" + DeviceId + "&ir=" + count; // CLOUD URL
    http.begin(URL); // MAKE HTTP CONNECTION WITH CLOUD
    http.addHeader("Content-Type", "application/x-www-form-urlencoded");    // SPECIFY CONTENT-TYPE HEADER
    int httpCode = http.GET();   // SEND HTTP GET REQUEST TO CLOUD
    payload = http.getString();    // RESPONSE FROM CLOUD 
    Serial.println(payload);  // PRINT PAYLOAD
    http.end();  // Close connection


        // BLINK LED TO INDICATE ONE CYCLE OF HTTP REQUEST
        digitalWrite(LED,1);
        delay(500);  
        digitalWrite(LED,0);
        delay(500);  
        digitalWrite(LED,1);
        delay(500);  
        digitalWrite(LED,0);
        delay(500);
}
}

delay(500);  
// END OF CODE
}
