#include <Arduino.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266WiFi.h>  

#define LED D0  // DECLARE LED TO PIN D0 (ON BOARD LED)
#define xInput A0 // DECLARE xInput TO PIN A0 (X AXIS OF ACCELEROMETER SENSOR IS TO ANALOG PIN A0)

const char* ssid = "Elins Tech."; // PUT SSID OF YOUR WIFI HERE
const char* password = "jaimatadi21";  // PUT PASSWORD OF YOUR WIFI HERE

// initialize minimum and maximum Raw Ranges for each axis
int RawMin = 0;
int RawMax = 1023;
int xRaw; 

// Take multiple samples to reduce noise
const int sampleSize = 10;

// Take samples and return the average value
int ReadAxis(int axisPin)
{
  long reading = 0;
//  reading = analogRead(axisPin);
  delay(1);
  for (int i = 0; i < sampleSize; i++)
  {
  reading += analogRead(axisPin);
  }
  return reading/sampleSize;
}


void setup() {
    delay(5000);  
    Serial.begin(9600); // INITIALIZE UART SERIAL MONITOR TO DISPLAY EVENTS  
    pinMode(LED,OUTPUT); // DECLARE LED PIN AS OUTPUT PIN
    digitalWrite(LED,0); // INITIALIZE LED PIN WITH 0 - ON LED
    
    Serial.println();
    Serial.println();
    Serial.println();

    WiFi.begin(ssid,password);  // START WIFI CONNECTION WITH SSID PASSWORD
    Serial.print("[CONNECTING] WAIT ...");
    
    while (WiFi.status() != WL_CONNECTED) // WAIT TILL WIFI IS CONNECTED
    {
      delay(100);
      Serial.print(".");
    }
    
    Serial.println("WIFI CONNECTED SUCCESSFULLY");    

      xRaw = ReadAxis(xInput);  //TAKE FIRST READING

}

String payload="";
String DeviceId="juvinagrawal651";  // CHANGE IT WITH DEVICE ID RECEIVED FROM CLOUD
HTTPClient http; 

int pos;

void loop(){


  //ACCELEROMETER CODE TO FIND RUNNING STATUS OF VEHICLE
  int xRawP = ReadAxis(xInput);
  int xRawN = xRawP - xRaw;


  Serial.print("X :: ");
  Serial.println(xRawN);
  xRaw = xRawP;

  if((xRawN>=-12)&&(xRawN<=12))
  {
    Serial.println("Standing Vehicle");  
    pos=0;
  }
  else
  {
    Serial.println("Moving Vehicle");   
    pos=1; 
  }


// CODE TO UPLOAD SENSOR DATA ON ELINS CLOUD
if(WiFi.status() == WL_CONNECTED)
{
  String URL = "";
    URL = URL + "http://elinstechnologies.com/netobox_v1/http_axis_device.php?id=" + DeviceId + "&pos=" + pos; // CLOUD URL
    http.begin(URL); // MAKE HTTP CONNECTION WITH CLOUD
    http.addHeader("Content-Type", "application/x-www-form-urlencoded");    // SPECIFY CONTENT-TYPE HEADER
    int httpCode = http.GET();   // SEND HTTP GET REQUEST TO CLOUD
    payload = http.getString();    // RESPONSE FROM CLOUD 
    Serial.println(payload);  // PRINT PAYLOAD
    http.end();  // Close connection


        // BLINK LED TO INDICATE ONE CYCLE OF HTTP REQUEST
        digitalWrite(LED,1);
        delay(500);  
        digitalWrite(LED,0);
        delay(500);  
        digitalWrite(LED,1);
        delay(500);  
        digitalWrite(LED,0);
        delay(500);
}

delay(500);  
// END OF CODE
}
