#include <Arduino.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266WiFi.h>  

const char* ssid = "Elins Tech."; // PUT SSID OF YOUR WIFI HERE
const char* password = "jaimatadi21";  // PUT PASSWORD OF YOUR WIFI HERE


void setup() {
    delay(5000);  
    Serial.begin(9600); // INITIALIZE UART SERIAL MONITOR TO DISPLAY EVENTS  
    pinMode(D0,OUTPUT); // DECLARE PIN D0 AS OUTPUT PIN - ON BOARD LED
    pinMode(D1,OUTPUT); // DECLARE PIN D1 AS OUTPUT PIN - RELAY IS CONNECTED WITH IT
    digitalWrite(D0,0); // INITIALIZE PIN D0 WITH 0 - ON ONBOARD LED
    digitalWrite(D1,0); // INITIALIZE PIN D1 WITH 0 - OFF RELAY
    
    Serial.println();
    Serial.println();
    Serial.println();

    WiFi.begin(ssid,password);  // START WIFI CONNECTION WITH SSID PASSWORD
    Serial.print("[CONNECTING] WAIT ...");
    
    while (WiFi.status() != WL_CONNECTED) // WAIT TILL WIFI IS CONNECTED
    {
      delay(100);
      Serial.print(".");
    }
    
    Serial.println("WIFI CONNECTED SUCCESSFULLY");    
}

String payload="";
String DeviceId="juvinagrawal651";  // CHANGE IT WITH DEVICE ID RECEIVED FROM CLOUD
HTTPClient http; 

void loop(){

if(WiFi.status() == WL_CONNECTED)
{
  String URL = "";
    URL = URL + "http://elinstechnologies.com/netobox_v1/http_device.php?id=" + DeviceId; // CLOUD URL
    http.begin(URL); // MAKE HTTP CONNECTION WITH CLOUD
    http.addHeader("Content-Type", "application/x-www-form-urlencoded");    // SPECIFY CONTENT-TYPE HEADER
    int httpCode = http.GET();   // SEND HTTP GET REQUEST TO CLOUD
    payload = http.getString();    // RESPONSE FROM CLOUD 
    Serial.println(payload);  // PRINT PAYLOAD
    http.end();  // Close connection

        if(payload.equals("ON"))  // PAYLOAD = ON, RELAY ON
        {
          digitalWrite(D1,1);
        }
        else if(payload.equals("OFF"))  // PAYLOAD = OFF, RELAY OFF
        {
          digitalWrite(D1,0);
        }

        // BLINK LED TO INDICATE ONE CYCLE OF HTTP REQUEST
        digitalWrite(D0,1);
        delay(500);  
        digitalWrite(D0,0);
        delay(500);  
        digitalWrite(D0,1);
        delay(500);  
        digitalWrite(D0,0);
        delay(3000);
}

delay(500);  
// END OF CODE
}
