#include <Arduino.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266WiFi.h>  
#include <SoftwareSerial.h>
#include <DHT.h>
#include <DHT_U.h>

#define LED D0  // DECLARE LED TO PIN D0 (ON BOARD LED)
#define DHTPIN D7 // DECLARE DHTPIN TO PIN D7 (DHT11 SENSOR IS CONNECTED AT D7)
#define DHTTYPE    DHT11     // SELECT DHT 11 SENSOR OF DHT SERIES
DHT_Unified dht(DHTPIN, DHTTYPE); // CREATE OBJECT dht WITH DHTPIN AND DHTTYPE

const char* ssid = "Elins Tech."; // PUT SSID OF YOUR WIFI HERE
const char* password = "jaimatadi21";  // PUT PASSWORD OF YOUR WIFI HERE


void setup() {
    delay(5000);  
    Serial.begin(9600); // INITIALIZE UART SERIAL MONITOR TO DISPLAY EVENTS  
    pinMode(LED,OUTPUT); // DECLARE LED PIN AS OUTPUT PIN
    pinMode(DHTPIN,INPUT); // DECLARE DHT PIN AS INPUT PIN 
    digitalWrite(LED,0); // INITIALIZE LED PIN WITH 0 - ON LED

    // CODE TO INITIALISE DHT11 SENSOR FOR TEMPERATURE MEASUREMENT
    dht.begin();
    sensor_t sensor;
    dht.temperature().getSensor(&sensor);
    
    Serial.println();
    Serial.println();
    Serial.println();

    WiFi.begin(ssid,password);  // START WIFI CONNECTION WITH SSID PASSWORD
    Serial.print("[CONNECTING] WAIT ...");
    
    while (WiFi.status() != WL_CONNECTED) // WAIT TILL WIFI IS CONNECTED
    {
      delay(100);
      Serial.print(".");
    }
    
    Serial.println("WIFI CONNECTED SUCCESSFULLY");    
}

String payload="";
String DeviceId="juvinagrawal651";  // CHANGE IT WITH DEVICE ID RECEIVED FROM CLOUD
HTTPClient http; 

int t=0;

void loop(){

  // CODE TO CALCULATE TEMPERATURE FROM DHT11 SENSOR
  sensors_event_t event;
  dht.temperature().getEvent(&event);
  if (isnan(event.temperature)) {
    Serial.println(F("Error reading temperature!"));
  }
  else {
    t = event.temperature; // HERE TEMPERATURE IS STORED IN t VARIABLE
  }
  Serial.println(t);
  
    

// CODE TO UPLOAD SENSOR DATA ON ELINS CLOUD
    String URL = "";
    URL = URL + "http://elinstechnologies.com/netobox_v1/http_dht_device.php?id=" + DeviceId + "&t=" + t; // CLOUD URL
    http.begin(URL); // MAKE HTTP CONNECTION WITH CLOUD
    http.addHeader("Content-Type", "application/x-www-form-urlencoded");    // SPECIFY CONTENT-TYPE HEADER
    int httpCode = http.GET();   // SEND HTTP GET REQUEST TO CLOUD
    payload = http.getString();    // RESPONSE FROM CLOUD 
    Serial.println(payload);  // PRINT PAYLOAD
    http.end();  // Close connection


        // BLINK LED TO INDICATE ONE CYCLE OF HTTP REQUEST
        digitalWrite(LED,1);
        delay(500);  
        digitalWrite(LED,0);
        delay(500);  
        digitalWrite(LED,1);
        delay(500);  
        digitalWrite(LED,0);
        delay(500);

delay(5000);  
// END OF CODE
}
