#include <Arduino.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266WiFi.h>  

#define LED D0  // DECLARE LED TO PIN D0 (ON BOARD LED)
#define TRIG D5 // DECLARE TRIG TO PIN D5 (IR SENSOR IS CONNECTED)
#define ECHO D6 // DECLARE ECHO TO PIN D6 (IR SENSOR IS CONNECTED)

long microsecondsToCentimeters(long microseconds);

const char* ssid = "Elins Tech."; // PUT SSID OF YOUR WIFI HERE
const char* password = "jaimatadi21";  // PUT PASSWORD OF YOUR WIFI HERE


void setup() {
    delay(5000);  
    Serial.begin(9600); // INITIALIZE UART SERIAL MONITOR TO DISPLAY EVENTS  
    pinMode(LED,OUTPUT); // DECLARE LED PIN AS OUTPUT PIN
    pinMode(TRIG,OUTPUT); // DECLARE TRIG PIN AS OUTPUT PIN 
    pinMode(ECHO,INPUT); // DECLARE ECHO PIN AS INPUT PIN 
    digitalWrite(LED,0); // INITIALIZE LED PIN WITH 0 - ON LED
    
    Serial.println();
    Serial.println();
    Serial.println();

    WiFi.begin(ssid,password);  // START WIFI CONNECTION WITH SSID PASSWORD
    Serial.print("[CONNECTING] WAIT ...");
    
    while (WiFi.status() != WL_CONNECTED) // WAIT TILL WIFI IS CONNECTED
    {
      delay(100);
      Serial.print(".");
    }
    
    Serial.println("WIFI CONNECTED SUCCESSFULLY");    
}

String payload="";
String DeviceId="juvinagrawal651";  // CHANGE IT WITH DEVICE ID RECEIVED FROM CLOUD
HTTPClient http; 

int distance;
long duration;

void loop(){


  // ULTRASONIC SENSOR CODE TO MEASURE OIL LEVEL IN TANK
  // Sensor is triggered by a HIGH pulse of 2 or more microseconds.
  // Give a short LOW pulse beforehand to ensure a clean HIGH pulse:
  digitalWrite(TRIG, LOW);
  delayMicroseconds(2);
  digitalWrite(TRIG, HIGH);
  delayMicroseconds(5);
  digitalWrite(TRIG, LOW);

  // duration is the time (in microseconds) from the sending of the ping
  // to the reception of its echo off of an object.
  duration = pulseIn(ECHO, HIGH);

  // convert the time into a distance
  distance = microsecondsToCentimeters(duration);

  Serial.print("Distance: ");
  Serial.print(distance);
  Serial.println("cm");
  

// CODE TO UPLOAD SENSOR DATA ON ELINS CLOUD
    String URL = "";
    URL = URL + "http://elinstechnologies.com/netobox_v1/http_sr_device.php?id=" + DeviceId + "&sr=" + distance; // CLOUD URL
    http.begin(URL); // MAKE HTTP CONNECTION WITH CLOUD
    http.addHeader("Content-Type", "application/x-www-form-urlencoded");    // SPECIFY CONTENT-TYPE HEADER
    int httpCode = http.GET();   // SEND HTTP GET REQUEST TO CLOUD
    payload = http.getString();    // RESPONSE FROM CLOUD 
    Serial.println(payload);  // PRINT PAYLOAD
    http.end();  // Close connection


        // BLINK LED TO INDICATE ONE CYCLE OF HTTP REQUEST
        digitalWrite(LED,1);
        delay(500);  
        digitalWrite(LED,0);
        delay(500);  
        digitalWrite(LED,1);
        delay(500);  
        digitalWrite(LED,0);
        delay(500);

delay(5000);  
// END OF CODE
}

long microsecondsToCentimeters(long microseconds) {
  // The speed of sound is 340 m/s or 29 microseconds per centimeter.
  // The ping travels out and back, so to find the distance of the object we
  // take half of the distance travelled.
  return microseconds / 29 / 2;
}
